<?php
$site = ['name' => 'Promi Blick', 'domain' => 'https://promi-blick.net'];

$posts = [

    [
        'title' => 'Packaged Cookies: A Sweet Staple of Modern Snacking',
        'category' => 'Food',
        'excerpt' => 'In today’s fast-paced world, where convenience often dictates food choices, packaged,',
        'link' => 'packaged-cookies-a-sweet-staple-of-modern-snacking',
        'image' => 'assets/images/sa1.jpeg'
    ],
    [
        'title' => 'Cats: Mystical, Majestic, and Lovable Companions',
        'category' => 'Pet',
        'excerpt' => 'Few animals have captured human imagination as much as cats. Mysterious, independent',
        'link' => 'cats-mystical-majestic-and-lovable-companions',
        'image' => 'assets/images/sa4.jpeg'
    ],
    [
        'title' => 'Lablabi: Tunisia’s Heartwarming Chickpea Soup',
        'category' => 'Food',
        'excerpt' => 'When it comes to comfort food from North Africa, few dishes rival the humble yet',
        'link' => 'lablabi-tunisias-heartwarming-chickpea-soup',
        'image' => 'assets/images/sa2.jpeg'
    ],
    [
        'title' => 'Hedgehogs: Nature’s Prickly Little Charmers',
        'category' => 'Pet',
        'excerpt' => 'With their tiny, round bodies, adorable snouts, and signature spines, hedgehogs have',
        'link' => 'hedgehogs-natures-prickly-little-charmers',
        'image' => 'assets/images/sa5.jpeg'
    ],
    [
        'title' => 'Korma: The Royal Curry That Defines Comfort and Elegance',
        'category' => 'Food',
        'excerpt' => 'Few dishes carry the regal charm, aromatic richness, and comforting warmth of Korma',
        'link' => 'korma-the-royal-curry-that-defines-comfort-and-elegance',
        'image' => 'assets/images/sa3.jpeg'
    ],


];

$hero  = array_slice($posts, 0, 3);

?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($site['name']) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" rel="stylesheet">

    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: #f1f5f9;
            color: #0f172a;
        }

        .container {
            max-width: 1100px;
        }

        .category {
            background: #ca8a04;
            color: #1c1917;
            font-size: 12px;
            padding: 4px 10px;
            border-radius: 9999px;
            font-weight: 600;
        }

        .swiper-pagination-bullet {
            background: #0f172a;
            opacity: 0.3;
        }

        .swiper-pagination-bullet-active {
            opacity: 1;
        }
    </style>
</head>

<body>

    <?php include('header.php'); ?>




    <!-- HERO SLIDER (EDITORIAL SPLIT) -->
    <section class="bg-white border-b">
        <div class="swiper heroSwiper">
            <div class="swiper-wrapper">

                <?php foreach ($hero as $post): ?>
                    <div class="swiper-slide">
                        <div class="container mx-auto px-6 py-16 grid md:grid-cols-2 gap-12 items-center">

                            <!-- TEXT -->
                            <div>
                                <span class="category"><?= htmlspecialchars($post['category']) ?></span>

                                <h2 class="text-4xl font-bold leading-tight mt-4">
                                    <?= htmlspecialchars($post['title']) ?>
                                </h2>

                                <p class="mt-4 text-slate-600 leading-relaxed max-w-md">
                                    <?= htmlspecialchars($post['excerpt']) ?>
                                </p>

                                <a href="<?= $post['link'] ?>"
                                    class="inline-block mt-6 px-6 py-3 border border-slate-900 text-slate-900 font-semibold hover:bg-slate-900 hover:text-white transition">
                                    Read full story →
                                </a>
                            </div>

                            <!-- IMAGE -->
                            <div>
                                <img src="<?= $post['image'] ?>"
                                    alt="<?= htmlspecialchars($post['title']) ?>"
                                    class="rounded-xl w-full h-[360px] object-cover">
                            </div>

                        </div>
                    </div>
                <?php endforeach ?>

            </div>

            <!-- PAGINATION -->
            <div class="container mx-auto px-6 pb-8">
                <div class="swiper-pagination !relative"></div>
            </div>
        </div>
    </section>

    <!-- LATEST ARTICLES -->
    <section class="container mx-auto px-6 py-16">
        <h3 class="text-2xl font-semibold mb-10">Latest Articles</h3>

        <div class="space-y-12">
            <?php foreach ($posts as $post): ?>
                <article class="grid md:grid-cols-3 gap-6 items-start bg-white p-6 rounded-lg border border-slate-200">
                    <img src="<?= $post['image'] ?>"
                        alt="<?= htmlspecialchars($post['title']) ?>"
                        class="rounded-md h-40 w-full object-cover">

                    <div class="md:col-span-2">
                        <span class="category"><?= htmlspecialchars($post['category']) ?></span>

                        <h4 class="text-xl font-semibold mt-3 leading-snug">
                            <?= htmlspecialchars($post['title']) ?>
                        </h4>

                        <p class="text-slate-600 mt-2 text-sm leading-relaxed">
                            <?= htmlspecialchars($post['excerpt']) ?>
                        </p>

                        <a href="<?= $post['link'] ?>"
                            class="inline-block mt-4 text-teal-700 text-sm font-medium hover:underline">
                            Continue reading →
                        </a>
                    </div>
                </article>
            <?php endforeach ?>
        </div>
    </section>




    <?php include('footer.php'); ?>

    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script>
        new Swiper('.heroSwiper', {
            loop: true,
            autoplay: {
                delay: 5000
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true
            },
            speed: 700
        });
    </script>

</body>

</html>